<?php

namespace Iranserver\Basics\Authenticatable;


use Iranserver\Basics\Authenticatable\User;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


class AuthServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $this->registerPolicies();

        Auth::viaRequest('custom_token', function (Request $request) {

            if (!$userId = $request->header('user-id')) return null;

            return new User([
                'id' => $userId,
            ]);
        });
    }
}
