<?php
namespace Iranserver\ApiServiceProvider\Exceptions;

use Exception;

class ResellerException extends Exception
{
    public static function fromResponse(array $response): self
    {
        $message = data_get($response, 'error.message', "internal server error");
        if (is_array($message)) $message = implode(' ', $message);
        $code = data_get($response, 'error.status', 500);
        return new self($message, $code);
    }
}