<?php
namespace Iranserver\ApiServiceProvider;

use GuzzleHttp\Client;
use Illuminate\Http\Client\HttpClientException;
use Exception;
use Illuminate\Support\Traits\Macroable;
use Psr\Http\Message\ResponseInterface;

class Api extends Client
{
    use Macroable;

    private $token;

    public function login($username, $password, $scopes = []): array
    {
        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        $response = $this->post('oauth/token', ['form_params' => [
            'grant_type'    => 'password',
            'client_id'     => config('api.client_id'),
            'client_secret' => config('api.client_secret'),
            'username'      => trim($username),
            'password'      => $password,
            'scope'         => implode(" ", $scopes)
        ]]);

        $content = $response->getBody()->getContents();
        $responseArray = json_decode($content, true);

        if ($error = data_get($responseArray, 'error.message')) {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw new HttpClientException($error);
        }

        if (isset($responseArray['access_token'])) {
            session()->put('api', $responseArray);
            return $responseArray;
        }

        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        throw new Exception($content);
    }

    public function loginWithId($id, $scopes = []): array
    {
        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        $response = $this->post('createToken', ['form_params' => [
            'name'          => 'Domain Password Grant Client',
            'client_id'     => config('api.client_id'),
            'client_secret' => config('api.client_secret'),
            'reseller_id'   => $id,
            'scope'         => implode(" ", $scopes)
        ]]);

        $content = $response->getBody()->getContents();
        $responseArray = json_decode($content, true);

        if ($error = data_get($responseArray, 'error.message')) {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw new HttpClientException($error);
        }

        if (isset($responseArray['data']['access_token'])) {
            session()->put('api', $responseArray['data']);
            return $responseArray['data'];
        }

        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        throw new Exception($content);
    }

    public function request(string $method, $uri = '', array $options = []): ResponseInterface
    {
        if ($this->token) $options['headers']['Authorization'] = sprintf("Bearer %s", $this->token);
        return parent::request($method, $uri, $options);
    }

    public function setToken($token)
    {
        $this->token = $token;
    }

    public function getToken()
    {
        return $this->token;
    }
}