<?php

namespace Iranserver\ApiServiceProvider\helpers;

use Lcobucci\JWT\Token;
use Lcobucci\JWT\Configuration;
use Lcobucci\JWT\Signer\Rsa\Sha256;
use Lcobucci\JWT\Signer\Key\InMemory;
use Lcobucci\JWT\Validation\Constraint\SignedWith;

class Jwt
{
    public static function parse($token): Token
    {
        $config = Configuration::forUnsecuredSigner();
        return $config->parser()->parse($token);
    }

    public static function validate($token, $signedWith): bool
    {
        $config = Configuration::forUnsecuredSigner();
        $token = $config->parser()->parse($token);
        return $config->validator()->validate($token, new SignedWith(
            new Sha256(),
            InMemory::plainText($signedWith)
        ));
    }
}