<?php
namespace Iranserver\ApiServiceProvider;

use GuzzleHttp\Client;
use Exception;
use Illuminate\Support\Traits\Macroable;
use Iranserver\ApiServiceProvider\Exceptions\ResellerException;

class P2P extends Client
{
    use Macroable;

    public function __construct(array $config = [])
    {
        parent::__construct($config);

        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        $response = $this->post('oauth/token', ['form_params' => [
            'grant_type'    => 'client_credentials',
            'client_id'     => config('api.client_id'),
            'client_secret' => config('api.client_secret'),
            'scope'         => 'full-admin'
        ]]);

        $content = $response->getBody()->getContents();
        $responseArray = json_decode($content, true);

        if (isset($responseArray['error'])) {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw ResellerException::fromResponse($responseArray);
        }

        if (isset($responseArray['access_token'])) {
            $config['headers']['Authorization'] = sprintf(
                "%s %s", $responseArray['token_type'], $responseArray['access_token']
            );
            parent::__construct($config);
        }

        else {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw new Exception($content);
        }
    }
}