<?php
namespace Iranserver\ApiServiceProvider;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Exception;
use Illuminate\Support\Traits\Macroable;
use Psr\Http\Message\ResponseInterface;
use Iranserver\ApiServiceProvider\Exceptions\ResellerException;

class Api extends Client
{
    use Macroable;

    private $token;

    public function logout()
    {
        try {
            session()->forget('api');
            $this->delete('logout');
        }
        catch (GuzzleException | Exception $e) {}
    }

    public function login($username, $password, $scopes = []): array
    {
        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        $response = $this->post('oauth/token', ['form_params' => [
            'grant_type'    => 'password',
            'client_id'     => config('api.client_id'),
            'client_secret' => config('api.client_secret'),
            'username'      => trim($username),
            'password'      => $password,
            'scope'         => implode(" ", $scopes)
        ]]);

        $content = $response->getBody()->getContents();
        $responseArray = json_decode($content, true);

        if (isset($responseArray['error'])) {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw ResellerException::fromResponse($responseArray);
        }

        if (isset($responseArray['access_token'])) {
            $this->setToken($responseArray['access_token']);
            session()->put('api', $responseArray);
            return $responseArray;
        }

        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        throw new Exception($content);
    }

    public function loginWithId($id, $scopes = []): array
    {
        $response = app(P2P::class)->post('createToken', ['form_params' => [
            'name'          => 'Domain Password Grant Client',
            'client_id'     => config('api.client_id'),
            'client_secret' => config('api.client_secret'),
            'reseller_id'   => $id,
            'scope'         => implode(" ", $scopes)
        ]]);

        $content = $response->getBody()->getContents();
        $responseArray = json_decode($content, true);

        if (isset($responseArray['error'])) {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw ResellerException::fromResponse($responseArray);
        }

        if (isset($responseArray['data']['access_token'])) {
            $this->setToken($responseArray['data']['access_token']);
            session()->put('api', $responseArray['data']);
            return $responseArray['data'];
        }

        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        throw new Exception($content);
    }

    public function request(string $method, $uri = '', array $options = []): ResponseInterface
    {
        if ($this->token) $options['headers']['Authorization'] = sprintf("Bearer %s", $this->token);
        return parent::request($method, $uri, $options);
    }

    public function setToken($token)
    {
        $this->token = $token;
    }

    public function getToken()
    {
        return $this->token;
    }
}