<?php

namespace Iranserver\ApiServiceProvider;

use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Str;
use Iranserver\ApiServiceProvider\helpers\Jwt;
use Iranserver\ApiServiceProvider\Middleware\IranserverOnlyMiddleware;

class ApiServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(__DIR__ . '/config/api.php', 'api');
        $this->loadTranslationsFrom(__DIR__ . '/resources/lang', 'api');

        $this->publishes([
            __DIR__ . '/resources/lang' => resource_path('lang/vendor/api')
        ], 'api-lang');

        $this->publishes([
            __DIR__ . '/config/api.php' => base_path('config/api.php')
        ], 'api-config');
    }

    public function boot()
    {
        /*
        |--------------------------------------------------------------------------
        | Register Api Singleton
        |--------------------------------------------------------------------------
        */

        $this->app->singleton(Api::class, function () {
            $config['base_uri'] = Str::finish(config('api.url'), '/');
            return new Api($config);
        });

        /*
        |--------------------------------------------------------------------------
        | Register Api Singleton
        |--------------------------------------------------------------------------
        */

        $this->app->singleton(P2P::class, function () {
            $config['base_uri'] = Str::finish(config('api.url'), '/');
            return new P2P($config);
        });

        /*
        |--------------------------------------------------------------------------
        | Authorize Logic For Session Base Panels
        |--------------------------------------------------------------------------
        */

        $this->app['auth']->viaRequest('api-panel', function (Request $request) {
            $api = app(Api::class);
            $user = config('api.user_model');
            $session = $request->session()->get('api');
            $token = 'Bearer ' . Arr::get($session, 'access_token');
            if ($payload = Jwt::decode($token)) {
                $api->setToken($token);
                return new $user([
                    'id'     => $payload['sub'],
                    'scopes' => $payload['scopes']
                ]);
            }
            return null;
        });

        /*
        |--------------------------------------------------------------------------
        | Authorize Logic When Token Is Provided
        |--------------------------------------------------------------------------
        */

        $this->app['auth']->viaRequest('api-microservice', function (Request $request) {
            $api = app(Api::class);
            $user = config('api.user_model');
            $token = $request->headers->get('Authorization');
            if ($payload = Jwt::decode($token)) {
                $api->setToken($token);
                return new $user([
                    'id'     => $payload['sub'],
                    'scopes' => $payload['scopes']
                ]);
            }
            return null;
        });

        /*
        |--------------------------------------------------------------------------
        | Register Middlewares
        |--------------------------------------------------------------------------
        */

        app()->bind('iranserver.only', IranserverOnlyMiddleware::class);
    }
}
