<?php
namespace Iranserver\ApiServiceProvider;

use GuzzleHttp\Client;
use Illuminate\Http\Client\HttpClientException;
use Exception;
use Psr\Http\Message\ResponseInterface;

class Api extends Client
{
    private $token;

    public function login($username, $password)
    {
        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        $response = $this->post('oauth/token', ['form_params' => [
            'grant_type'    => 'password',
            'client_id'     => config('api.client_id'),
            'client_secret' => config('api.client_secret'),
            'username'      => trim($username),
            'password'      => $password
        ]]);

        $content = $response->getBody()->getContents();
        $responseArray = json_decode($content, true);

        if ($error = data_get($responseArray, 'error.message')) {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw new HttpClientException($error);
        }

        if (isset($responseArray['access_token'])) {
            $responseArray['username'] = $username;
            session()->put('api', $responseArray);
            return $responseArray;
        }

        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        throw new Exception($content);
    }

    public function request(string $method, $uri = '', array $options = []): ResponseInterface
    {
        if ($this->token) $options['headers']['Authorization'] = $this->token;
        return parent::request($method, $uri, $options);
    }

    public function setToken($token)
    {
        $this->token = $token;
    }

    public function getToken()
    {
        return $this->token;
    }
}