<?php
namespace Iranserver\ApiServiceProvider;

use GuzzleHttp\Client;
use Illuminate\Http\Client\HttpClientException;
use Exception;

class P2P extends Client
{
    public function __construct(array $config = [])
    {
        parent::__construct($config);

        /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
        $response = $this->post('oauth/token', ['form_params' => [
            'grant_type'    => 'direct',
            'client_id'     => config('api.client_id'),
            'client_secret' => config('api.client_secret')
        ]]);

        $content = $response->getBody()->getContents();
        $responseArray = json_decode($content, true);

        if ($error = data_get($responseArray, 'error.message')) {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw new HttpClientException($error);
        }

        if (isset($responseArray['access_token'])) {
            $config['headers']['Authorization'] = 'Bearer ' . $responseArray['access_token'];
            parent::__construct($config);
        }

        else {
            /** @noinspection PhpUnhandledExceptionInspection Should handle in app */
            throw new Exception($content);
        }
    }
}