<?php

namespace Iranserver\ApiServiceProvider\helpers;

use Illuminate\Support\Str;

class Jwt
{
    public static function decode($token)
    {
        if (Str::startsWith($token, 'Bearer ')) {
            $token = substr($token, 7);
            $parts = explode('.', $token);
            if (count($parts) >= 3) {
                $payload = base64_decode($parts[1]);
                $payload = json_decode($payload, true) ?? [];
                if (isset($payload['sub'])) {
                    return [
                        'sub'    => $payload['sub'],
                        'scopes' => data_get($payload, 'scopes', [])
                    ];
                }
            }
        }
        return null;
    }
}