<?php
namespace Iranserver\ApiServiceProvider\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class ApiRequireTokenMiddleware
{
    public function handle($request, Closure $next, $reseller = null)
    {
        if (Auth::guest()) {
            abort(401, trans('api::msg.token-missing'));
        }

        if ($reseller and Auth::user()['id'] != $reseller) {
            abort(401, trans('api::msg.wrong-token'));
        }

        return $next($request);
    }
}