با استفاده از این ماژول میتوانید به سیستم api و oauth ایران سرور ارتباط برقرار کنید. استفاده از این پکیچ برای ارتباط با بستر api الزامی است.

### روش نصب

برای استفاده از این پکیچ تنظیمات زیر را به فایل composer.json خود اضافه کنید.

```json
"repositories": [
    {
        "type": "git",
        "url": "http://git.greenweb.local/iranserver-sdk/api-service-provider.git"
    }
]
```

سپس تنظیم secure-http را غیرفعال کنید.

```json
"config": {
    "secure-http": false
}
```

و نهایتا پکیج را نصب کنید.

```php
composer require iranserver/api-service-provider @dev
```

جهت جلوگیری از بروز خطا در آپدیت های بعدی پکیج، لطفا ورژن مورد نظر خود را در فایل composer تعیین کنید.

### تنظیمات لاراول
در لاراول نیازی به انجام هیچ تنظیماتی نیست و provider بصورت خودکار فعال میشود.

جهت تغییر تنظیمات پیشفرض provider از دستور زیر استفاده کنید.

```php
php artisan vendor:publish --tag=api-config
```

جهت تغییر در ترجمه متون از دستور زیر استفاده کنید.

```php
php artisan vendor:publish --tag=api-lang
```

### تنظیمات lumen

در لومن برای فعال کردن provider باید در فایل bootstrap/app.php کد زیر را اضافه کنید.

```php
$app->configure('api');
$app->register(Iranserver\ApiServiceProvider\ApiServiceProvider::class);
```

و فایل کانفیگ provider را از داخل vendor به مسیر config انتقال دهید.

چنانچه نیاز به تغییر زبان دارید فایل زبان را نیز انتقال دهید.

### نحوه استفاده از auth

برای محافظت کردن صفحات و api ها در لومن و لاراول تنظیمات زیر را در مسیر config/auth.php اضافه کنید.

```php
'guards' => [
    'web' => [
        'driver' => 'api-panel'
    ],

    'api' => [
        'driver' => 'api-microservice'
    ]
]
```

### لاگین نماینده

جهت لاگین کردن نماینده در کنترلر مربوط به لاگین به روش زیر عمل کنید.

```php
<?php
namespace App\Http\Controllers;

use Iranserver\ApiServiceProvider\Api;

class LoginController extends Controller
{
    public function login(Request $request, Api $api)
    {
        $this->validate($request, [
            'username'             => 'required|email',
            'password'             => 'required'
        ]);

        try {
            $api->login($request['username'], $request['password']);
            return redirect()->route('home');
        }

        catch ( Exception $e ) {
            return redirect()->route('login')->withErrors('There is an error with login credentials.');
        }
    }
}
```
