<table id="logs_table" class="datatable datatable-custom col-xs-12">
    <thead>
    <tr>
        <th class="col-xs-2">تاریخ</th>
        <th class="col-xs-5">توضیحات</th>
        <th class="col-xs-2">نام کاربری</th>
        <th class="col-xs-2">آی پی</th>
    </tr>
    </thead>
</table>

<script>
    $(document).ready(function () {
        let $dt_form;

        window.addEventListener('filter.change', function (e) {
            $dt_form = e.detail;
            dt.ajax.reload();
        });

        let dt = $('#logs_table').DataTable({
            language: {
                processing: 'در حال بارگذاری...',
                infoEmpty: 'چیزی برای نمایش وجود ندارد.',
                infoFiltered: '',
                infoPostFix: '',
                loadingRecords: 'در حال بارگیری...',
                zeroRecords: 'جستجو شما نتیجه ای نداشته است.',
                emptyTable: 'داده ای موجود نمی باشد.',
                paginate: {
                    first: 'اولین صفحه',
                    previous: 'صفحه قبلی',
                    next: 'صفحه بعدی',
                    last: 'آخرین صفحه'
                },
                null: 'انتخاب نشده',
            },
            bAutoWidth: false,
            bLengthChange: false,
            bInfo: false,
            searching: false,
            paging: true,
            pageLength: 20,
            processing: true,
            serverSide: true,
            order: [[0, "desc"]],
            ajax: {
                "url"  : "{$admin_link}&action=dashboard/logs&userid={$user_id}",
                "type" : "post",
                "data" : (d) => {
                    if ($dt_form) {
                        Object.assign(d, {
                            filter: {
                                user         : $dt_form.find("#filter_user").val(),
                                description  : $dt_form.find("#filter_description").val(),
                                ipaddr       : $dt_form.find("#filter_ipaddr").val(),
                                date_start   : $dt_form.find("#filter_date_start").val(),
                                date_end     : $dt_form.find("#filter_date_end").val()
                            }
                        })
                    }
                }
            },
            columns : [
                {
                    class: "nowrap type_b",
                    data: "date"
                },
                {
                    class: "col-xs-8 type_a",
                    data: "description",
                    render: function (data) {
                        let escaped = escape_HTML(data);

                        if (escaped.length < 150) {
                            return escaped.replace("<br>", "");
                        } else {
                            return escaped.replace("<br>", "").substring(0, 150) + '...' + show_more_icon(escaped) ;
                        }
                    }
                },
                {
                    class: "nowrap type_b",
                    data: "user"
                },
                {
                    class: "nowrap type_b",
                    data: "ipaddr"
                }
            ],
            drawCallback : function(settings) {
                $('#logs_table .show_more').tooltip();
            }
        });
    });

    function escape_HTML(html_str) {
        'use strict';
        return html_str.replace(/[&<>"]/g, function (tag) {
            let chars_to_replace = {
                '&': '&',
                '<': '<',
                '>': '>',
                '"': ' ',
            };
            return chars_to_replace[tag] || tag;
        });
    }

    function show_more_icon(text) {
        return ' <div data-toggle="tooltip" data-placement="top" title="' +text+ '" class="show_more"><i class="fas fa-search"></i></div>';
    }
</script>
