<?php

namespace is\core\components;

use is\core\BaseApp;
use WHMCS\Config\Setting;

/**
 * Trait Addon
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Addon
{
    public function registerAddon()
    {
        if (!$this->runningInConsole()) $this->directAccess();
        $this->response->setVars([
            'admin_link'  => 'addonmodules.php?module=' . $this->get('module_name'),
            'client_link' => 'index.php?m=' . $this->get('module_name'),
            'base_url'    => Setting::getValue('SystemURL')
        ]);
    }

    public function getAddonConfig(): array
    {
        return [
            "name"        => $this->get('title'),
            "description" => $this->get('description'),
            "version"     => $this->get('version'),
            "author"      => $this->get('author'),
            "fields"      => $this->get('addon.fields')
        ];
    }

    public function whmcsMailConfig():? array
    {
        $keys = ['SystemEmailsFromEmail', 'SystemEmailsFromName', 'DisableEmailSending', 'MailConfig'];
        $setting = Setting::query()->whereIn('setting', $keys)->pluck('value', 'setting')->toArray();
        $smtp = localAPI('DecryptPassword', ['password2' => $setting['MailConfig'] ?? '']);
        $smtp = json_decode($smtp['password'] ?? '', true);

        if ($setting['DisableEmailSending'] ?? false or !$smtp or $smtp['module'] != 'SmtpMail') {
            return null;
        }

        return [
            'enable'   => true,
            'host'     => $smtp['configuration']['host'],
            'username' => $smtp['configuration']['username'],
            'password' => $smtp['configuration']['password'],
            'secure'   => $smtp['configuration']['secure'],
            'port'     => $smtp['configuration']['port'],
            'from'     => $setting['SystemEmailsFromEmail'],
            'name'     => $setting['SystemEmailsFromName']
        ];
    }

    private function directAccess()
    {
        $enable = $this->get('security.enable', true);
        $publicFolders = $this->get('security.public_folders', ['assets']);
        $stubFile = __DIR__ . "/../addon/stubs/.htaccess.stub";
        $htaccessFile = $this->getRootPath('.htaccess');

        if ($enable and $publicFolders) {
            $content = file_get_contents($stubFile);
            $content = strtr($content, ['%folders%' => implode("|", $publicFolders)]);
            if (!is_file($htaccessFile) or md5_file($htaccessFile) != md5($content)) {
                file_put_contents($htaccessFile, $content);
            }
        }
        else {
            if (is_file($htaccessFile)) unlink($htaccessFile);
        }
    }

    public function isConfigAddonPage(): bool
    {
        return basename($_SERVER['SCRIPT_FILENAME'] ?? "") == 'configaddonmods.php';
    }

    public function isAdmin($id): bool
    {
        return ($_SESSION['adminid'] ?? null) == $id;
    }
}
