<?php
declare(strict_types=1);

namespace tests\console;

use is\core\console\Command;
use is\core\console\Input;
use PHPUnit\Framework\TestCase;
use ArgumentCountError;

class CommandTest extends TestCase
{
    protected function setUp(): void
    {
        Input::fill(0, []);
    }

    public function testInvalidCommand(): void
    {
        $this->expectException(ArgumentCountError::class);
        new Command(['bar']);
    }

    public function testValidCommand(): void
    {
        $command = new Command(['bar', function () { return "some result."; }]);
        $commandWithArray = new Command(['bar', [function () { return "some result."; }, 'else']]);

        $this->assertInstanceOf(Command::class, $command);
        $this->assertInstanceOf(Command::class, $commandWithArray);

        Input::fill(1, [1 => 'bar']);
        $this->assertIsArray($command->match());
        $this->assertIsArray($commandWithArray->match());

        $this->assertEquals('__invoke', $command->match()[1]);
        $this->assertEquals('else', $commandWithArray->match()[1]);

        Input::fill(1, [1 => 'none']);
        $this->assertNull($command->match());
        $this->assertNull($commandWithArray->match());
    }
}