<?php

namespace tests\components;

use is\core\BaseApp;
use is\core\shared\Str;
use PHPUnit\Framework\TestCase;
use DateTime;
use is\core\components\Menu;
use is\core\components\Core;

class CoreTest extends TestCase
{
    /** @var BaseApp */
    public $app;

    protected function setUp(): void
    {
        $this->app = new class extends BaseApp
        {
            public function config(): array
            {
                return [
                    'module_name' => 'test',
                    'title'       => 'test app',
                    'description' => 'just for test',
                    'version'     => '1.0',
                    'author'      => 'Pooya'
                ];
            }
        };
    }

    public function testSet(): void
    {
        $this->app->set('test.start', $now = new DateTime());
        $this->assertInstanceOf(DateTime::class, $this->app->get('test.start'));
    }

    public function testGet(): void
    {
        $this->assertEquals('test', $this->app->get('module_name'));
    }

    public function testGetRootPath(): void
    {
        $this->assertEquals(Str::normalizePath(__DIR__), Str::normalizePath($this->app->getRootPath()));
        $this->assertEquals(Str::normalizePath(__DIR__ . '/some-dir/x.php'), Str::normalizePath($this->app->getRootPath('some-dir/x.php')));
        $this->assertEquals(Str::normalizePath(__DIR__ . '/some-dir/x.php'), Str::normalizePath($this->app->getRootPath('/some-dir/x.php')));
        $this->assertEquals(Str::normalizePath(__DIR__ . '/some-dir/x.php'), Str::normalizePath($this->app->getRootPath('some-dir\x.php')));
    }

    public function testRun(): void
    {
        $this->expectOutputString('404 NOT FOUND');
        $this->app->run();
    }

    public function testUses(): void
    {
        $this->assertTrue($this->app->uses(Core::class));
        $this->assertFalse($this->app->uses(Menu::class));
    }
}