<?php

namespace is\core\controllers;

use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Str;
use is\core\BaseApp;
use is\core\components\Upgradeable;

/**
 * Class NewReleasesController
 * @package is\core\controllers
 *
 * @property BaseApp|Upgradeable $app
 */
class NewReleasesController extends BaseController
{
    public function __invoke()
    {
        $moduleName = $this->app->get('module_name');
        $userVersion = $this->get('version', 0);
        $download = $this->get('download');
        $fileRegex = "/^$moduleName-(\d+(?:\.\d+)*)-(\d+)\.zip$/i";

        if ($this->get('php_version') && $this->get('php_version') > 8) {
            preg_match('/^(\d+\.\d+)/',$this->get('php_version'), $matches);
            $php_version = $matches[0];
        }

        $fs = new Filesystem();
        $dir_path = $this->app->getReleasePath($php_version);
        if (!$fs->isDirectory($dir_path)) return [];

        $files = $fs->files($dir_path);
        $lastVersion = collect($files)
            ->filter(function ($item) use ($fileRegex) {
                return preg_match($fileRegex, $item->getBasename());
            })
            ->sort(function ($a, $b) use ($fileRegex) {
                preg_match($fileRegex, $a->getBasename(), $matchA);
                preg_match($fileRegex, $b->getBasename(), $matchB);
                return $matchA[2] > $matchB[2] ? 1 : -1;
            })
            ->last();

        if (!$lastVersion) return [];

        preg_match($fileRegex, $lastVersion->getBasename(), $match);
        if (version_compare($userVersion, $match[1], '>=')) return [];

        if ($download) {
            $path = !empty($php_version) ? "$php_version/" . $lastVersion->getBasename() : $lastVersion->getBasename();
            return $this->file($this->app->getReleasePath($path));
        }

        if (preg_match_all(
            '/##\s+\[v(\d+(?:\.\d+)*)]\s+-\s+\d{4}-\d{2}-\d{2}([\s\S]+?)(?:(?=##)|$)/',
            file_get_contents($this->app->getChangeLogFilePath()),
            $matches
        )) {
            foreach ($matches[1] as $i => $ver) {
                if (version_compare($ver, $userVersion, '>'))
                    $notes[$ver] = collect(explode(PHP_EOL, $matches[2][$i]))
                        ->map(function ($item) { return trim($item, '-'); })
                        ->map(function ($item) { return trim($item); })
                        ->filter()
                        ->values()
                        ->toArray();
            }
        }

        return [
            'name' => $moduleName,
            'filename' => $lastVersion->getBasename(),
            'version' => $match[1],
            'release_date' => date("Y/m/d", $match[2]),
            'release_note' => $notes ?? []
        ];
    }
}