<?php

namespace is\core\components;

use is\core\BaseApp;

/**
 * Trait Requirements
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'requirements' => [
 *          'some string' => function($app) { return true; },
 *          'other string' => true or false
 *     ]
 * ]
 */
trait Requirements
{
    public function checkRequirements()
    {
        $requirements = $this->get('requirements', []);
        $errors = [];
        foreach ($requirements as $msg => $requirement) {
            if (is_callable($requirement)) $requirement = $requirement($this);
            if (!$requirement) {
                $errors[] = $msg;
            }
        }
        return $errors;
    }
}