<?php

namespace is\core\controllers;

use is\core\response\Smarty;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

/**
 * Trait WithExcel
 * @package is\core\controllers
 * @mixin BaseController
 *
 * @usage: composer require phpoffice/phpspreadsheet
 * Use the trait in your project and enjoy :)
 * You can use it by calling this Excel method and giving data, title
 */
trait WithExcel
{
    public function excel($data, array $title): string
    {
        header('Content-Type: application/octet-stream');
        header("Content-Transfer-Encoding: utf-8");
        header('Content-disposition: attachment; filename="status_' . date('Ymd', time()) . '.xlsx"');

        $objPHPExcel = new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->setRightToLeft(true);

        for ($i = 65; $i < count($title) + 65; $i++) {
            $chars [] = chr($i);
        }

        foreach (array_combine(array_slice((array)$chars, 0, count($title)), $title) as $key => $value) {
            $objPHPExcel->getActiveSheet()->setCellValue($key . '1', $value);
        }

        $objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFill()->setFillType('solid')->getStartColor()->setARGB(/** @lang text */ 'FFEEEEEE');
        $objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('A1:O' . count($data))->getAlignment()->setHorizontal('center');

        foreach ($chars as $value) {
            $objPHPExcel->getActiveSheet()->getColumnDimension($value)->setAutoSize(true);
        }

        $rowNumber = 2;
        foreach ($data as $item) {
            foreach ($item as $key => $value) {
                $objPHPExcel->getActiveSheet()->setCellValueExplicit($chars[$key] . $rowNumber, $value, DataType::TYPE_STRING);
            }
            $rowNumber++;
        }

        $file = $this->app->getRootPath("/storage/tmp/excel_" . $_SESSION['adminid'] . ".xlsx");
        if (!is_dir(dirname($file))) mkdir(dirname($file), 0777, true);
        $objWriter = new Xlsx($objPHPExcel);
        $fp = fopen($file, "w");
        $objWriter->save($fp);
        fclose($fp);
        readfile($file);
        exit();
    }

    public function excelBtn(callable $func, array $titles)
    {
        if ($this->get('excel') == 1) {
            $this->excel($func(), $titles);
        }


        $this->app->response->prepend(new Smarty([
            __DIR__ . "/../views/excel-btn.tpl",
        ]));
    }
}