<?php

namespace is\core\console;

use is\core\BaseApp;
use is\core\components\Log;
use is\core\routes\RouteInterface;
use is\core\shared\Obj;

class Schedule implements RouteInterface
{
    use Obj;

    public $action;
    public $commands = [];
    public $entrypoint = 'command.php';
    public $phpBinary;

    public function __construct($config = [])
    {
        $config = $this->populate($config, ['action', 'commands']);
        $this->requiredArgs($config, 'action', 'commands');

        if (!$this->phpBinary) {
            $this->phpBinary = PHP_BINARY;
        }
    }

    public function input(): string
    {
        return Input::$argv[1] ?? '';
    }

    public function match():? array
    {
        if ($this->input() === $this->action) {
            return [
                function (BaseApp $app) {
                    $entrypoint = $app->getRootPath($this->entrypoint);
                    $cmd = '';
                    foreach ($this->commands as $command) {
                        /** @var BaseApp|Log $app */
                        $output = $app->uses(Log::class) ? $app->getLogPath("commands/$command.log") : "/dev/null";
                        $cmd .= "{$this->phpBinary} $entrypoint {$command} > $output & ";
                    }
                    exec($cmd);
                    return $cmd . PHP_EOL;
                }
            ];
        }
        return null;
    }
}