<?php

namespace is\core\components;

use is\core\BaseApp;

/**
 * Trait Cache
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'cache' => [
 *         'path' => 'storage/cache'
 *     ]
 * ]
 */
trait Cache
{
    public function getCachePath($path = ''): string
    {
        $path = ltrim($path, "/\\");
        return $this->getRootPath($this->get('cache.path', 'storage/cache') . "/$path");
    }

    public function remember($key, $minute, callable $func)
    {
        $file = md5($key);
        $dir  = substr($file, 0, 2);
        $fullname = $this->getCachePath("$dir/$file");
        if (file_exists($fullname) and filemtime($fullname) + $minute * 60 >= time()) {
            return json_decode(file_get_contents($fullname), true);
        }

        $data = json_encode($func());
        @ mkdir(dirname($fullname), 0755, true);
        file_put_contents($fullname, $data);
        return json_decode($data, true);
    }

    public function forget($key)
    {
        $file = md5($key);
        $dir  = substr($file, 0, 2);
        $fullname = $this->getCachePath("$dir/$file");
        @unlink($fullname);
    }
}