<?php

namespace is\core;

use is\core\components\Addon;
use is\core\components\Core;
use is\core\components\ErrorHandler;
use is\core\components\Response;
use is\core\components\Router;
use is\core\shared\Initiator;
use is\core\shared\Obj;

/**
 * Class BaseApp
 * @package is\core
 *
 * @example
 * [
 *     'module_name' => 'my_app',
 *     'title'       => 'sample app',
 *     'description' => 'this is a sample app',
 *     'version'     => '1.0',
 *     'author'      => 'Pooya <p.eraghi@greenweb.ir>',
 *     'env'         => 'production',
 *     'base_url'    => '',
 *     'routes' => [],
 *     'router' => [
 *         'node' => Route::class,
 *         'error' => ErrorController::class
 *     ],
 *     'menu' => [
 *         ['title', "action=xxx", 'icon' => 'fa fa-hand-holding-usd', 'beta' => true]
 *     ],
 *     'response' => [
 *         'class' => Response::class,
 *         'exitJson' => true,
 *         'viewPath' => 'templates'
 *     ],
 *     'addon' => [
 *         'fields' => []
 *     ],
 *     'security' => [
 *         'enable' => true,
 *         'public_folders' => ['assets']
 *     ],
 *     'mail' => [
 *         'enable' => true,
 *         'host' => '',
 *         'username' => '',
 *         'password' => '',
 *         'secure' => '',
 *         'port' => '',
 *         'from' => '',
 *         'name' => ''
 *     ],
 *     'log' => [
 *         'path' => '',
 *         'days' => 15
 *     ],
 *     'api' => [
 *         'url' => ''
 *     ]
 * ]
 *
 */
abstract class BaseApp
{
    // do not move components, order is important
    use Obj, Initiator, ErrorHandler, Core, Router, Response, Addon;

    public function __construct()
    {
        $this->config = $this->config();
        $this->requiredArgs($this->config, 'module_name', 'title', 'description', 'version', 'author');
        $this->callTraitsMethod('register');
        $this->callTraitsMethod('boot');
    }
}
