<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\response\Smarty;

/**
 * Trait Menu
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'menu' => [
 *         ['title', "action=xxx", 'icon' => 'fa fa-hand-holding-usd', 'beta' => true, 'when' => true]
 *     ]
 * ]
 */
trait Menu
{
    public function bootMenu()
    {
        $menu = $this->get('menu');
        if (!$this->runningInConsole() and $menu) {
            $this->response->prepend(new Smarty([
                __DIR__ . '/../views/menu.tpl',
                [
                    'id'   => $this->get('module_name') . "_menu",
                    'data' => $menu
                ]
            ]));
        }
    }
}
