<?php

namespace is\core\testing;

use is\core\BaseApp;
use is\core\shared\Sys;
use PHPUnit\Framework\TestCase as BaseTestCase;

/**
 * Class TestCase
 * @package is\core\testing
 * @mixin MigrateDatabase
 */
abstract class TestCase extends BaseTestCase
{
    /** @var BaseApp */
    protected $app;

    protected function setUp(): void
    {
        parent::setUp();

        $uses = Sys::classUsesRecursive($this);
        if (in_array(MigrateDatabase::class, $uses)) $this->migrateDatabase();

        $this->app = $this->createApp();
    }

    protected function createApp()
    {
        if ($app = getenv("APP_CLASS")) {
            return new $app();
        }
        return null;
    }
}