<?php

namespace is\core\controllers;

use is\core\BaseApp;
use is\core\response\Response;
use is\core\shared\Arr;

class BaseController
{
    /** @var BaseApp */
    protected $app;

    public function __construct(BaseApp $app)
    {
        $this->app = $app;
    }

    public function view($tpl, $vars = []): Response
    {
        return $this->app->response->view($this->app->getViewPath("$tpl.tpl"), $vars);
    }

    public function partial($tpl, $vars = []): Response
    {
        $this->app->response->partial = true;
        $this->app->response->exit = true;
        return $this->app->response->view($this->app->getViewPath("$tpl.tpl"), $vars);
    }

    public function file($file): Response
    {
        return $this->app->response->file($file);
    }

    public function datatable(array $data, $total): array
    {
        return [
            "draw" => $this->post('draw', 1),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $data
        ];
    }

    public function back()
    {
        $url = htmlspecialchars_decode($_SERVER['HTTP_REFERER'] ?? '/');
        header("location: $url");
        exit;
    }

    public function get($key, $default = null)
    {
        return Arr::get($_GET ?? [], $key, $default);
    }

    public function post($key, $default = null)
    {
        return Arr::get($_POST ?? [], $key, $default);
    }

    public function isGet(): bool
    {
        return 'get' == strtolower($_SERVER['REQUEST_METHOD'] ?? '');
    }

    public function isPost(): bool
    {
        return 'post' == strtolower($_SERVER['REQUEST_METHOD'] ?? '');
    }

    public function isAjax(): bool
    {
        return 'xmlhttprequest' == strtolower(getallheaders()['X-Requested-With'] ?? '')
            or 'xmlhttprequest' == strtolower(getallheaders()['x-requested-with'] ?? '');
    }
}