<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\controllers\NewReleasesController;
use is\core\controllers\UpgradeController;
use is\core\routes\Route;

/**
 * Class Upgradeable
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'upgrade' => [
 *         'menu' => true,
 *         'endpoint' => 'https://some-domain.com',
 *         'release_path' => 'releases',
 *         'changelog_file' => 'CHANGELOG.md'
 *     ]
 * ]
 */
trait Upgradeable
{
    public function registerUpgradeable()
    {
        if (!$this->runningInConsole()) {
            $this->shouldUse(Cache::class);
            $this->shouldUse(Requirements::class);

            $this->addRoute(new Route(['upgrade-module', UpgradeController::class]));
            $this->addRoute(new Route(['api/new-releases', NewReleasesController::class]));
            $this->config['menu'][] = ['بروزرسانی ماژول', "action=upgrade-module", 'icon' => 'fas fa-download', 'when' => $this->get('upgrade.menu', true)];
            $this->config['access_control']['public_routes'][] = 'api/new-releases';
            $this->config['requirements'][sprintf('جهت استفاده از امکان بروزرسانی خودکار، مسیر %s باید قابلیت نوشتن داشته باشد.', realpath($this->getRootPath()))] = function() { return is_writable($this->getRootPath()); };
        }
    }

    public function getReleasePath($path = ''): string
    {
        $path = ltrim($path, "/\\");
        return $this->getRootPath($this->get('upgrade.release_path', "releases") . "/$path");
    }

    public function getChangeLogFilePath(): string
    {
        return $this->getRootPath($this->get('upgrade.changelog_file', "CHANGELOG.md"));
    }
}