<?php

namespace is\core\response;

use is\core\shared\Obj;

class File implements Section
{
    use Obj;

    public $file;

    public function __construct($config = [])
    {
        $this->populate($config, 'file');
    }

    public function render(array $vars = []): string
    {
        $filename = basename($this->file);

        header('Content-Type: application/octet-stream');
        header("Content-Transfer-Encoding: Binary"); 
        header("Content-Disposition: attachment; filename=$filename");
        header("Content-Length: " . filesize($this->file));

        return file_get_contents($this->file);
    }
}