<?php

namespace is\core\components;

use is\core\BaseApp;
use Sentry\Severity;
use function Sentry\withScope as sentryWithScope;
use function Sentry\captureMessage as sentryCaptureMessage;
use function Sentry\init as sentryInit;
use Sentry\State\Scope;

/**
 * Class Sentry
 * @package is\core\components
 *
 * @mixin BaseApp
 * @usage composer require sentry/sdk 2.0.3
 * @example
 * [
 *     'sentry' => [
 *         'dsn' => 'https://54521as5dasdad25@sentry.example.com/0'
 *     ]
 * ]
 */
trait Sentry
{
    private $sentryFingerPrint;

    public function registerSentry()
    {
        /** @noinspection PhpIncludeInspection */
        $composer = require $this->getRootPath('vendor/autoload.php');
        $composer->loadClass('Composer\InstalledVersions');
        $options = $this->get('sentry', []);
        if ($options) sentryInit($options);
    }

    public function info(string $description, array $data = []): void
    {
        $this->log('info', $description, $data);
    }

    public function error(string $description, array $data = []): void
    {
        $this->log('error', $description, $data);
    }

    private function log(string $level, string $description, array $data = []): void
    {
        //if (!$this->sentryFingerPrint) $this->sentryFingerPrint = session_id();

        sentryWithScope(function (Scope $scope) use ($level, $description, $data): void {
            $scope->setExtra('payload', $data);
            //$scope->setFingerprint([$this->sentryFingerPrint]);
            sentryCaptureMessage($description, new Severity($level));
        });
    }
}