<?php

namespace is\core\shared;

class Arr
{
    public static function get($target, string $key = null, $default = null)
    {
        if (is_null($key)) {
            return $target;
        }

        $key = explode(".", $key);

        foreach ($key as $k => $segment) {
            unset($key[$k]);

            if ($segment === '*') {
                if (!$key) return $target;
                $temp = [];
                foreach ($target as $row) $temp[] = self::get($row, implode('.', $key));
                return array_filter($temp) ?: $default;
            }

            else if (is_array($target) and isset($target[$segment])) $target = $target[$segment];
            else if (is_object($target) and property_exists($target, $segment)) $target = $target->$segment;
            else return $default;
        }

        return $target;
    }

    public static function has($target, string $key): bool
    {
        return !self::get($target, $key, new Nothing) instanceof Nothing;
    }

    public static function set(&$target, string $key, $value)
    {
        $key = explode(".", $key);

        foreach ($key as $k => $segment) {
            unset($key[$k]);

            if (!is_array($target) and !is_object($target)) {
                return $value;
            }

            if ($segment === '*') {
                foreach ($target as $j => $_) {
                    self::set($target, implode('.', array_merge([$j], $key)), $value);
                }
                return $value;
            }

            if (is_array($target)) {
                if (!isset($target[$segment])) $target[$segment] = [];
                $target = &$target[$segment];
            }
            else if (is_object($target)) {
                if (!property_exists($target, $segment)) $target->$segment = [];
                $target = &$target->$segment;
            }
        }

        return $target = $value;
    }
}