<?php

namespace is\core\components;

use is\core\BaseApp;

/**
 * Class MultipleLog
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait MultipleLog
{
    use Log, Sentry {
        Log::log as baseLog;
        Sentry::log as sentryLog;
    }

    public function info(string $description, array $data = []): void
    {
        $this->log('info', $description, $data);
    }

    public function error(string $description, array $data = []): void
    {
        $this->log('error', $description, $data);
    }

    private function log(string $level, string $description, array $data = []): void
    {
        $this->baseLog($level, $description, $data);
        $this->sentryLog($level, $description, $data);
    }
}