<?php

namespace is\core\components;

use is\core\BaseApp;

/**
 * Class HasRegistrarModule
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'registrar' => [
 *         'src' => 'registrar_module',
 *         'name' => 'my_app'
 *     ]
 * ]
 */
trait HasRegistrarModule
{
    public function registerHasRegistrarModule()
    {
        $src = $this->getRootPath($this->get('registrar.src', 'registrar_module'));
        $dest = $this->getRegistrarModulesPath($this->get('registrar.name', $this->get('module_name')));
        if (!is_link($dest)) {
            symlink($src, $dest);
        }
    }

    public function getRegistrarModulesPath($path = ''): string
    {
        $path = ltrim($path, "/\\");
        return $this->getRootPath("/../../registrars/$path");
    }
}