<?php

namespace is\core\response;

use is\core\shared\Obj;
use Smarty as SmartyEngine;

class Smarty implements Section
{
    use Obj;

    public $tpl;
    public $vars = [];
    public $smarty;

    public function __construct($config = [])
    {
        $this->smarty = new SmartyEngine();
        $config = $this->populate($config, ['tpl', 'vars']);
        $this->requiredArgs($config, 'tpl');
    }

    public function render(array $vars = []): string
    {
        $this->smarty->assign(array_merge($vars, $this->vars));
        ob_start();
        $this->smarty->display($this->tpl);
        return ob_get_clean();
    }
}