<?php

namespace is\core\response;

class Response
{
    public $httpStatus = [
        403 => "FORBIDDEN",
        404 => "NOT FOUND"
    ];

    private $statusCode = 200;
    private $vars = [];

    /** @var Section[][] */
    private $sections = [
        'before' => [],
        'main'   => [],
        'after'  => []
    ];

    private $partial = false;
    public  $hasJson = false;
    public  $hasFile = false;

    public function setVars($vars): self
    {
        if (is_array($vars)) $this->vars = array_merge($this->vars, $vars);
        else $this->vars[$vars] = func_get_args()[1] ?? null;
        return $this;
    }

    public function append(Section $section): self
    {
        $this->sections['after'][] = $section;
        return $this;
    }

    public function prepend(Section $section): self
    {
        $this->sections['before'][] = $section;
        return $this;
    }

    public function setContent(Section $section): self
    {
        if ($section instanceof Json) {
            $this->partial = $this->hasJson = true;
        }

        else if ($section instanceof File) {
            $this->partial = $this->hasFile = true;
        }

        $this->sections['main'][0] = $section;
        return $this;
    }

    public function view($tpl, $vars = []): Response
    {
        return $this->setContent(new Smarty([$tpl, $vars]));
    }

    public function json(array $array): Response
    {
        return $this->setContent(new Json([$array]));
    }

    public function raw(string $text): Response
    {
        return $this->setContent(new PlainText([$text]));
    }

    public function file(string $file): Response
    {
        return $this->setContent(new File([$file]));
    }

    public function setStatus($code): self
    {
        $this->statusCode = $code;
        return $this;
    }

    public function render(): string
    {
        if ($this->partial) {
            $output = isset($this->sections['main'][0])
                ? $this->sections['main'][0]->render($this->vars)
                : "";
        }

        else {
            $output = "";
            foreach ($this->sections as $group) {
                foreach ($group as $section) {
                    $output .= $section->render($this->vars);
                }
            }
        }

        http_response_code($this->statusCode);
        return $output;
    }

    public function map($func)
    {
        foreach ($this->sections as $key => $group) {
            foreach ($group as $section) {
                $func($section, $key);
            }
        }
    }
}