<?php

namespace is\core\controllers;

use is\core\BaseApp;
use is\core\components\Log;
use is\core\shared\Arr;

/**
 * Class LogsController
 * @package is\core\controllers
 *
 * @property BaseApp|Log $app
 */
class LogsController extends BaseController
{
    public function __invoke(): string
    {
        $filename = $this->get('date', date('Y-m-d'));
        $filename = $this->app->getLogPath("log-$filename.log");
        if (!file_exists($filename)) return '';

        $logRegex = '/(?:^|\r\n|\n|\r)\[(\d{4}-\d{2}-\d{2}\s\d{2}:\d{2}:\d{2})]\s([\S]+)\s(.+)/i';
        $extraNewLine = '/(\r\n|\n|\r)+(?!\[)/';
        $colors = [
            'info'  => '#07589e',
            'error' => '#da2424'
        ];

        $data = preg_replace($extraNewLine, " ↵ ", file_get_contents($filename));

        if (preg_match_all($logRegex, $data, $m)) {
            $response = [];
            foreach ($m[1] as $i => $date) {
                $color = Arr::get($colors, $m[2][$i], '#000');
                $response[] =
                    sprintf("<span style='background:#bce4c3;padding:1px'>%s</span> ", $date) .
                    sprintf("<span style='color:%s'>%s</span> ", $color, $m[2][$i]) .
                    sprintf("<span style='color:#454545'>%s</span> ", mb_substr($m[3][$i], 0, 400));
            }

            return sprintf(
                "<div style='font-family:monospace;direction:ltr'>%s</div>",
                implode("<hr style='margin:3px auto'>", $response)
            );
        }

        return '';
    }
}