<?php

namespace is\core\controllers;

use is\core\BaseApp;
use is\core\components\Log;
use Unirest\Request;
use ZipArchive;

/**
 * Class UpgradeController
 * @package is\core\controllers
 *
 * @property BaseApp|Log $app
 */
class UpgradeController extends BaseController
{
    public function __invoke()
    {
        $currentVersion = $this->app->get('version');
        if ($this->post('upgrade')) $this->upgrade($currentVersion);

        $newVersion = $this->app->remember("check-for-update", 60 * 24, function () use ($currentVersion) {
            $response = Request::get($this->app->get('upgrade.endpoint'), [], ['version' => $currentVersion]);
            if ($response->code == 200) {
                return $response->body;
            }
            else {
                $this->app->error("Check for update", (array) $response->body);
                return null;
            }
        });

        return $this->app->response->view(__DIR__ . "/../views/upgrade.tpl", compact('currentVersion', 'newVersion'))
            ->setVars('error', $this->app->checkRequirements());
    }

    public function upgrade($currentVersion)
    {
        $log = $this->app->uses(Log::class);

        $moduleName = $this->app->get('module_name');
        $filename = $this->app->getRootPath("$moduleName.zip");
        $response = Request::get($this->app->get('upgrade.endpoint'), [], ['version' => $currentVersion, 'download' => 1]);

        if ($response->code == 200) {
            $bytes = file_put_contents($filename, $response->raw_body);
            if ($log) $this->app->info("Zip file downloaded:", ['bytes' => $bytes]);
            $zip = new ZipArchive();
            if ($zip->open($filename))
            {
                $extracted = $zip->extractTo(dirname(dirname(dirname($filename))));
                if ($log) $this->app->info("Zip file extracted:", ['status' => $extracted]);
                $zip->close();
                $unlinked = unlink($filename);
                if ($log) $this->app->info("Zip file deleted:", ['status' => $unlinked]);
                $this->app->forget('check-for-update');
                sleep(5);
                $this->back();
            }
        }
        else {
            if ($log) $this->app->info("Upgrade api has error:", [
                'status' => $response->code,
                'body' => (array) $response->body
            ]);
        }
    }
}