<?php

namespace is\core\components;

use is\core\BaseApp;

/**
 * Trait I18N
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'i18n' => [
 *         'lang' => 'english',
 *         'fallback' => 'english',
 *         'path' => 'lang',
 *         'data' => []
 *     ]
 * ]
 */
trait I18N
{
    public function registerI18N()
    {
        $lang = $this->get('i18n.lang', 'english');
        $fallback = $this->get('i18n.fallback', 'english');

        $langFile = $this->getLangPath("$lang.php");
        if (!file_exists($langFile)) $langFile = $this->getLangPath("$fallback.php");

        /** @noinspection PhpIncludeInspection */
        $data = require $langFile;
        $this->config['i18n']['data'] = $data;
        $this->response->setVars('lang', $data);
    }

    public function t($key, ...$params)
    {
        return sprintf($this->get("i18n.data.$key", $key), ...$params);
    }

    public function getLangPath($path = ''): string
    {
        $path = ltrim($path, "/\\");
        return $this->getRootPath($this->get('i18n.path', "lang") . "/$path");
    }
}