<?php

namespace is\core\controllers;

use is\core\components\I18N;

class ErrorController extends BaseController
{
    public function __call($name, $arguments)
    {
        $status = substr($name, 1);
        $this->app->response->setStatus($status);
        $text = $this->app->uses(I18N::class) ? $this->app->t($this->app->response->httpStatus[$status]) : $this->app->response->httpStatus[$status];

        if ($this->isAjax()) {
            return ['error' => $text];
        }

        return sprintf("%s %s", $status, $text);
    }
}