<?php

namespace is\core\controllers;

use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Str;

class NewReleasesController extends BaseController
{
    public function __invoke()
    {
        $moduleName = $this->app->get('module_name');
        $userVersion = $this->get('version', 0);
        $download = $this->get('download');
        $fileRegex = "/^$moduleName-(\d+(?:\.\d+)*)-(\d+)\.zip$/i";

        $fs = new Filesystem();
        $files = $fs->files($this->app->getReleasePath());
        $lastVersion = collect($files)
            ->filter(function ($item) use ($fileRegex) {
                return preg_match($fileRegex, $item->getBasename());
            })
            ->sort(function ($a, $b) use ($fileRegex) {
                preg_match($fileRegex, $a->getBasename(), $matchA);
                preg_match($fileRegex, $b->getBasename(), $matchB);
                return $matchA[2] > $matchB[2] ? 1 : -1;
            })
            ->last();
        
        if (!$lastVersion) return [];
        preg_match($fileRegex, $lastVersion->getBasename(), $match);
        if (version_compare($userVersion, $match[1], '>=')) return [];

        if ($download) {
            return $this->file($this->app->getReleasePath($lastVersion->getBasename()));
        }

        if (preg_match_all(
            '/##\s+\[v(\d+(?:\.\d+)*)]\s+-\s+\d{4}-\d{2}-\d{2}([\s\S]+?)(?:(?=##)|$)/',
            file_get_contents($this->app->getChangeLogFilePath()),
            $matches
        )) {
            foreach ($matches[1] as $i => $ver) {
                if (version_compare($ver, $userVersion, '>'))
                    $notes[$ver] = collect(explode(PHP_EOL, $matches[2][$i]))
                        ->map(function ($item) { return trim($item, '-'); })
                        ->map(function ($item) { return trim($item); })
                        ->filter()
                        ->values()
                        ->toArray();
            }
        }

        return [
            'name' => $moduleName,
            'filename' => $lastVersion->getBasename(),
            'version' => $match[1],
            'release_date' => date("Y/m/d", $match[2]),
            'release_note' => $notes ?? []
        ];
    }
}