<?php

namespace is\core\controllers;

use is\core\BaseApp;
use is\core\response\Smarty;
use is\core\response\Response;
use is\core\components\ActivityLog;

/**
 * Class ActivityLogsController
 * @package is\core\controllers
 *
 * @property BaseApp|ActivityLog $app
 */
class ActivityLogsController extends BaseController
{
    public function __invoke(): Response
    {
        $this->app->response->prepend(new Smarty([ __DIR__ . "/../views/activity_logs_assets.tpl" ]));
        $this->app->response->prepend(new Smarty([ __DIR__ . "/../views/activity_logs_filter.tpl" ]));

        return $this->app->response->view(__DIR__ . "/../views/activity_logs.tpl")
            ->setVars([
                'start_date' => date('Y-m-d'),
                'user_id'    => $this->get('userid'),
                'only'       => $this->get('only'),
            ]);
    }

    public function logApi(): array
    {
        $filters = $this->post('filter', []);
        $field = ["date", "description", "user", "ipaddr"];
        $orderCol = $this->post('order.0.column', 0);
        $orderDir = $this->post('order.0.dir', 'desc');

        $user_id = $this->get('userid');
        $moduleName = $this->get('module');
        $is_sys_log = $moduleName == 'system_logs';
        $only = $is_sys_log ? $this->get('only') : $moduleName;

        $query = $this->app->getDb()->table("tblactivitylog")
            ->when($user_id,                        function ($q) use ($user_id) { $q->where('userid', $user_id); })
            ->when($only,                           function ($q) use ($only)    { $q->where('description', 'like', "[$only]%"); })
            ->when(!empty($filters['user']),        function ($q) use ($filters) { $q->where('user', $filters['user']); })
            ->when(!empty($filters['description']), function ($q) use ($filters) { $q->where('description', 'like', "%{$filters['description']}%"); })
            ->when(!empty($filters['ipaddr']),      function ($q) use ($filters) { $q->where('ipaddr', 'like', "%{$filters['ipaddr']}%"); })
            ->when(!empty($filters['date_start']),  function ($q) use ($filters) { $q->whereDate('date', '>=', $filters['date_start']); })
            ->when(!empty($filters['date_end']),    function ($q) use ($filters) { $q->whereDate('date', '<=', $filters['date_end']); });

        $count = $query->count();
        $data  = $query->orderBy($field[$orderCol], $orderDir)
            ->offset($this->post('start', 0))
            ->limit(50)
            ->get()
            ->map(function ($item) use ($only) {
                if ($only) {
                    $item->description = preg_replace("/^\[$only]:(?:json)?\s+(.+)/", '$1', $item->description);
                }

                if (0 < (int) $item->admin_id) {
                    $item->user = "Admin ID " . $item->admin_id . "<br/>" .
                        '<div class="truncate" style="max-width:200px;color:#bbb;">'.$item->user.'</div>';
                }
                elseif (0 < (int) $item->user_id) {
                    $item->user = "User ID " . $item->user_id . "<br/>" .
                        '<div class="truncate" style="max-width:200px;color:#bbb;">'.$item->user.'</div>';
                }

                return $item;
            });

        return $this->datatable($data->toArray(), $count);
    }
}