<?php

namespace is\core\components;

use is\core\BaseApp;
use Illuminate\Database\Capsule\Manager as Capsule;
use is\core\controllers\ErrorController;
use is\core\routes\Route;

/**
 * Trait SimpleAccessControl
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'access_control' => [
 *         'public_routes' => ['route/input'],
 *         'default_route' => 'dashboard'
 *     ]
 * ]
 */
trait SimpleAccessControl
{
    public function registerSimpleAccessControl()
    {
        if ($this->isConfigAddonPage() and !$this->runningInConsole()) {
            $accessRoles = Capsule::table('tbladdonmodules')
                ->where('module', $this->get('module_name'))
                ->where('setting','access')
                ->value('value');
            $accessRoles = explode(',', $accessRoles);
            $accessRoles = Capsule::table('tbladminroles')->whereIn('id', $accessRoles)->pluck('name', 'id');

            foreach ($accessRoles as $id => $role) {
                $this->config['addon']['fields']["SAC_$id"] = [
                    "FriendlyName" => $role,
                    "Type"         => "text",
                    "Size"         => "200",
                    "Default"      => "*"
                ];
            }
        }
    }


    /**
     * Dashboard route should be like this -> ['', EmailController::class],
     * Give dashboard access to admin then page is accessible
     */
    public function bootSimpleAccessControl()
    {
        if (!$this->runningInConsole()) {
            $adminId = data_get($_SESSION, 'adminid');
            $adminRoleId = Capsule::table('tbladmins')->where('id', $adminId)->value('roleid');
            $perms = Capsule::table('tbladdonmodules')
                ->where('module', $this->get('module_name'))
                ->where('setting',"SAC_$adminRoleId")
                ->value('value');
            $perms = explode(',', $perms);
            if (!in_array('*', $perms)) {
                $routes =& $this->config['routes'];
                foreach ($routes as $i => $route) {
                    if ($route->input() == "" and in_array($this->get("default_route", "dashboard"), $perms)) continue;
                    if (
                        !in_array($route->input(), $this->get('access_control.public_routes', [])) and
                        !in_array($route->input(), $perms)
                    ) $routes[$i] = new Route([$route->input(), [ErrorController::class, 'e403']]);
                }
            }
        }
    }
}
