<?php
declare(strict_types=1);

namespace tests\shared;

use PHPUnit\Framework\TestCase;
use is\core\shared\Obj;

class ObjTest extends TestCase
{
    public function testPopulateObjectWithArray(): void
    {
        $obj = new class ([1, 2, 'extra' => 3]) {
            use Obj;

            public $first;
            public $second;
            public $extra;

            public function __construct($config = [])
            {
                $this->populate($config, ['first', 'second']);
            }
        };

        $this->assertEquals(1, $obj->first);
        $this->assertEquals(2, $obj->second);
        $this->assertEquals(3, $obj->extra);
    }
}