<?php
namespace is\core\console;

use is\core\routes\RouteInterface;
use is\core\shared\Obj;

class Command implements RouteInterface
{
    use Obj;

    public $action;
    public $command;

    public function __construct($config = [])
    {
        $config = $this->populate($config, ['action', 'command']);
        $this->requiredArgs($config, 'action', 'command');
    }

    public function input(): string
    {
        return Input::$argv[1] ?? '';
    }

    public function match():? array
    {
        if ($this->input() === $this->action) {
            return is_array($this->command) ? $this->command : [$this->command, '__invoke'];
        }
        return null;
    }
}
