<?php
declare(strict_types=1);

use is\core\console\Command;
use PHPUnit\Framework\TestCase;
use is\core\BaseApp;
use is\core\console\Input;

class AppRouterTest extends TestCase
{
    /** @var BaseApp */
    public $app;

    protected function setUp(): void
    {
        Input::fill(0, []);
        
        $this->app = new class extends BaseApp
        {
            public function config(): array
            {
                return [
                    'module_name' => 'test',
                    'title'       => 'test app',
                    'description' => 'just for test',
                    'version'     => '1.0',
                    'author'      => 'Pooya',

                    'routes' => [
                        new Command(['foo', function () { return "command result."; }]),
                        ['route', function () { return "route result."; }]
                    ]
                ];
            }
        };
    }

    public function testValidCommand(): void
    {
        $this->expectOutputString('command result.');
        Input::fill(1, [1 => 'foo']);
        $this->app->run();
    }

    public function testValidRoute(): void
    {
        $this->expectOutputString('route result.');
        $_GET['action'] = 'route';
        $this->app->run();
    }

    public function test404NotFoundRoute(): void
    {
        $this->expectOutputString('404 NOT FOUND');
        $_GET['action'] = 'unknown-route';
        $this->app->run();
    }
}