<?php

namespace is\core\controllers;

use Unirest\Request;
use ZipArchive;

class UpgradeController extends BaseController
{
    public function __invoke()
    {
        $currentVersion = $this->app->get('version');
        if ($this->post('upgrade')) $this->upgrade($currentVersion);

        $newVersion = $this->app->remember("check-for-update", 60 * 24, function () use ($currentVersion) {
            $response = Request::get($this->app->get('upgrade.endpoint'), [], ['version' => $currentVersion]);
            if ($response->code == 200) {
                return $response->body;
            }
            else {
                $this->app->error("Check for update", (array) $response->body);
                return null;
            }
        });

        return $this->app->response->view(__DIR__ . "/../views/upgrade.tpl", compact('currentVersion', 'newVersion'))
            ->setVars('error', $this->app->checkRequirements());
    }

    public function upgrade($currentVersion)
    {
        $moduleName = $this->app->get('module_name');
        $filename = $this->app->getRootPath("$moduleName.zip");
        $response = Request::get($this->app->get('upgrade.endpoint'), [], ['version' => $currentVersion, 'download' => 1]);
        
        if ($response->code == 200) {
            file_put_contents($filename, $response->raw_body);
            $zip = new ZipArchive();
            if ($zip->open($filename))
            {
                $zip->extractTo(dirname(dirname($filename)));
                $zip->close();
                unlink($filename);
            }
        }

        $this->app->forget('check-for-update');
    }
}