<?php

namespace is\core\controllers;

use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Str;

class NewReleasesController extends BaseController
{
    public function __invoke()
    {
        $userVersion = $this->get('version', 0);
        $download = $this->get('download');
        $fs = new Filesystem();
        $files = $fs->files($this->app->getReleasePath());
        $lastVersion = collect($files)->max(function ($item) { return $item->getBasename(); });
        
        if (!$lastVersion) return [];
        [$name, $version, $timestamp] = explode("-", Str::replaceLast('.zip', '', $lastVersion));
        if (version_compare($userVersion, $version, '>=')) return [];

        if ($download) {
            return $this->file($this->app->getReleasePath($lastVersion));
        }

        if (preg_match_all(
            '/##\s+\[v(\d+(?:\.\d+)*)]\s+-\s+\d{4}-\d{2}-\d{2}([\s\S]+?)(?:(?=##)|$)/',
            file_get_contents($this->app->getChangeLogFilePath()),
            $matches
        )) {
            foreach ($matches[1] as $i => $ver) {
                if (version_compare($ver, $userVersion, '>'))
                    $notes[$ver] = collect(explode(PHP_EOL, $matches[2][$i]))
                        ->map(function ($item) { return trim($item, '-'); })
                        ->map(function ($item) { return trim($item); })
                        ->filter()
                        ->values()
                        ->toArray();
            }
        }

        return [
            'name' => $name,
            'filename' => $lastVersion,
            'version' => $version,
            'release_date' => date("Y-m-d", $timestamp),
            'release_note' => $notes ?? []
        ];
    }
}