<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\controllers\ErrorController;
use is\core\routes\Route;
use is\core\routes\RouteInterface;

/**
 * Trait Router
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Router
{
    public function registerRouter()
    {
        $node = $this->get('router.node', Route::class);
        $routes = $this->get('routes', []);

        $this->config['routes'] = array_map(function ($route) use ($node) {
            if ($route instanceof RouteInterface) return $route;
            else return new $node($route);
        }, $routes);
    }

    public function addRoute(RouteInterface $route)
    {
        $this->config['routes'][] = $route;
    }

    public function findRoute()
    {
        $routes = $this->get('routes', []);
        foreach ($routes as $route) {
            if ($controller = $route->match()) return $controller;
        }

        $errorController = $this->get('router.error', ErrorController::class);
        return [$errorController, 'e404'];
    }
}