<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\routes\Route;
use is\core\controllers\ActivityLogsController;

/**
 * Trait ActivityLog
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'activityLog' => [
 *         'menu' => true
 *     ]
 * ]
 */
trait ActivityLog
{
    public function registerActivityLog()
    {
        $this->addRoute(new Route(['activity-log', ActivityLogsController::class]));
        $this->addRoute(new Route(['api/activity-log', [ActivityLogsController::class, 'logApi']]));
        $this->config['menu'][] = ['گزارشات سیستم', "action=activity-log", 'icon' => 'fad fa-copy', 'when' => $this->get('activityLog.menu', true)];
    }

    public function activityLog($data, $userId = null): bool
    {
        $module = $this->get('module_name');

        /** @noinspection PhpUndefinedFunctionInspection */
        $api = localAPI('LogActivity', array_filter([
            'clientid'    => $userId,
            'description' => sprintf(
                "[%s]:%s %s",
                $module,
                is_string($data) ? '' : 'json',
                is_string($data) ? $data : json_encode($data)
            )
        ]));
        return $api['result'] === 'success';
    }
}
