<?php

namespace is\core\components;

use is\core\BaseApp;
use PHPMailer\PHPMailer\PHPMailer;

/**
 * Trait Mail
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Mail
{
    public function getMailer():? PHPMailer
    {
        if (!$this->get('mail.enable')) return null;

        $mail = new PHPMailer();
        $config = $this->get('mail');

        $mail->isSMTP();
        $mail->Host = $config['host'] ?? '';
        $mail->SMTPAuth = true;
        $mail->Username = $config['username'] ?? '';
        $mail->Password = $config['password'] ?? '';
        $mail->SMTPSecure = $config['secure'] ?? PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = $config['port'] ?? 465;

        if (isset($config['from'])) {
            /** @noinspection PhpUnhandledExceptionInspection */
            $mail->setFrom($config['from'], $config['name'] ?? '');
        }

        return $mail;
    }
}