<?php

namespace is\core\controllers;

use is\core\BaseApp;
use is\core\response\Smarty;
use is\core\response\Response;
use is\core\components\ActivityLog;

/**
 * Class ActivityLogsController
 * @package is\core\controllers
 *
 * @property BaseApp|ActivityLog $app
 */
class ActivityLogsController extends BaseController
{
    public function __invoke(): Response
    {
        $this->app->response->prepend(new Smarty([ __DIR__ . "/../views/activity_logs_assets.tpl" ]));
        $this->app->response->prepend(new Smarty([
            __DIR__ . "/../views/activity_logs_filter.tpl",
            [
                'start_date' => date('Y-m-d')
            ]
        ]));

        return $this->app->response->view(__DIR__ . "/../views/activity_logs.tpl");
    }

    public function logApi(): array
    {
        $filters = $this->post('filter', []);
        $field = ["date", "description", "user", "ipaddr"];
        $orderCol = $this->post('order.0.column', 0);
        $orderDir = $this->post('order.0.dir', 'desc');
        $moduleName  = $this->get('module');

        $query = $this->app->getDb()->table("tblactivitylog")
            ->when($moduleName != 'system_logs', function ($q) use ($moduleName) { $q->where('description', 'like', "[$moduleName]%"); })
            ->when(!empty($filters['user']), function ($q) use ($filters) { $q->where('user', $filters['user']); })
            ->when(!empty($filters['description']), function ($q) use ($filters) { $q->where('description', 'like', "%{$filters['description']}%"); })
            ->when(!empty($filters['ipaddr']), function ($q) use ($filters) { $q->where('ipaddr', 'like', "%{$filters['ipaddr']}%"); })
            ->when(!empty($filters['date_start']), function ($q) use ($filters) { $q->whereDate('date', '>=', $filters['date_start']); })
            ->when(!empty($filters['date_end']), function ($q) use ($filters) { $q->whereDate('date', '<=', $filters['date_end']); });
        $count = $query->count();
        $data  = $query->orderBy($field[$orderCol], $orderDir)
            ->offset($this->post('start', 0))
            ->limit(20)
            ->get()
            ->map(function ($item) use ($moduleName) {
                if ($moduleName != 'system_logs') {
                    $item->description = preg_replace("/^\[$moduleName]:(?:json)?\s+(.+)/", '$1', $item->description);
                }
                return $item;
            });

        return $this->datatable($data->toArray(), $count);
    }
}