<?php

namespace is\core;

use is\core\components\Core;
use is\core\components\ErrorHandler;
use is\core\components\Response;
use is\core\components\Router;
use is\core\shared\Initiator;
use is\core\shared\Obj;

/**
 * Class BaseApp
 * @package is\core
 *
 * @example
 * [
 *     'module_name' => 'my_app',
 *     'title'       => 'sample app',
 *     'description' => 'this is a sample app',
 *     'version'     => '1.0',
 *     'author'      => 'Pooya <p.eraghi@greenweb.ir>',
 *     'env'         => 'production',
 *     'base_url'    => '',
 *
 *     'routes' => [],
 *     'router' => [
 *         'node' => Route::class,
 *         'error' => ErrorController::class
 *     ],
 *
 *     'response' => [
 *         'class' => Response::class,
 *         'exitJson' => true,
 *         'viewPath' => 'templates'
 *     ]
 * ]
 *
 */
abstract class BaseApp
{
    // do not move components, order is important
    use Obj, Initiator, ErrorHandler, Core, Router, Response;

    public function __construct()
    {
        $this->config = $this->config();
        $this->requiredArgs($this->config, 'module_name', 'title', 'description', 'version', 'author');
        $this->callTraitsMethod('register');
        $this->callTraitsMethod('boot');
    }
}
